from MAVProxy.modules.planner_module import Module
from MAVProxy.modules import planner_util_message as mesg
import subprocess as sp
import cv2
import time
from os.path import expanduser,getctime
import glob
import thread
import numpy as np

class PersonSensor(Module):
    def init(self):
	self._process_type = 1
        self.controllables = ['has_Person']
	home = expanduser("~")
	self.path = home + '/.cache/mavproxy/captures/'
	self.count = 0
	
        command = "v4l2-ctl -d 0 -c exposure_auto=3" # -c exposure_absolute=2"
        output = sp.call(command, shell=True)
	return

    def has_Person(self):
	self._add_to_command_queue('has_Person')

    def _has_Person(self):
        t1 = time.time()

        cam = cv2.VideoCapture(0)
        for i in range(15):
            next, frame = cam.read()
        self.count += 1
        cv2.imwrite(self.path + str(self.count) + ".png", frame)
        cam.release()
        
        self._add_to_message_queue(mesg.PRINT,"Captured " + str(self.count) + " in " + str(time.time() - t1))
        
        hsv = cv2.cvtColor(frame, cv2.COLOR_BGR2HSV)
        lower_red1 = np.array([0,45,60])
        upper_red1 = np.array([15,255,240])
        lower_red2 = np.array([160,45,60])
        upper_red2 = np.array([255,255,240])
        mask = cv2.inRange(hsv, lower_red1, upper_red1) + cv2.inRange(hsv, lower_red2, upper_red2)
        
	num = len(mask[mask>200])
	self._add_to_message_queue(mesg.PRINT,"NUM red: " + str(num))
        if (num > 2000):
            self._add_to_event_queue('yes_Person')
            position = self._sharedmem.get_position()
            self._add_to_message_queue(mesg.FOUND,str(position[1]) + " " + str(position[0]))
        else:
            self._add_to_event_queue('no_Person')
        

    

